/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.config;

import filenet.vw.apps.config.VWConfigCore;
import filenet.vw.apps.config.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.VWConfigActionCommand;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.Container;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class VWConfigMenuBar
extends JMenuBar {
    private VWConfigCore m_configCore = null;
    private JMenu m_fileMenu = null;
    private JMenuItem m_exitItem = null;
    private JMenu m_helpMenu = null;
    private JMenuItem m_helpTopicsItem = null;
    private JMenuItem m_aboutItem = null;

    public VWConfigMenuBar(Container parent, VWConfigCore configCore) {
        this.m_configCore = configCore;
        this.initMenuBar(parent);
    }

    protected void releaseResources() {
        if (this.m_configCore == null) {
            return;
        }
        if (this.m_exitItem != null) {
            this.m_exitItem.removeActionListener(this.m_configCore);
            this.m_exitItem = null;
        }
        if (this.m_fileMenu != null) {
            this.m_fileMenu.removeAll();
            this.m_fileMenu = null;
        }
        if (this.m_helpTopicsItem != null) {
            this.m_helpTopicsItem.removeActionListener(this.m_configCore);
            this.m_helpTopicsItem = null;
        }
        if (this.m_aboutItem != null) {
            this.m_aboutItem.removeActionListener(this.m_configCore);
            this.m_aboutItem = null;
        }
        if (this.m_helpMenu != null) {
            this.m_helpMenu.removeAll();
            this.m_helpMenu = null;
        }
        this.m_configCore = null;
        this.removeAll();
    }

    private void initMenuBar(Container parent) {
        try {
            this.m_fileMenu = VWStringUtils.getMenuUsingString(VWResource.File_withHK);
            this.m_fileMenu.getAccessibleContext().setAccessibleName(this.m_fileMenu.getText());
            this.m_fileMenu.getAccessibleContext().setAccessibleDescription(this.m_fileMenu.getText());
            this.m_fileMenu.getAccessibleContext().setAccessibleParent(this);
            this.add(this.m_fileMenu);
            this.m_exitItem = VWStringUtils.getMenuItemUsingString(VWResource.Exit_withHK);
            this.m_exitItem.setActionCommand(VWConfigActionCommand.ACMD_EXIT);
            this.m_exitItem.addActionListener(this.m_configCore);
            this.m_exitItem.getAccessibleContext().setAccessibleName(this.m_exitItem.getText());
            this.m_exitItem.getAccessibleContext().setAccessibleDescription(this.m_exitItem.getText());
            this.m_exitItem.getAccessibleContext().setAccessibleParent(this.m_fileMenu);
            this.m_fileMenu.add(this.m_exitItem);
            JMenu settingsMenu = this.m_configCore.getSettingsMenu(this);
            if (settingsMenu != null) {
                this.add(settingsMenu);
            }
            this.m_helpMenu = VWStringUtils.getMenuUsingString(VWResource.Help_withHK);
            this.m_helpMenu.getAccessibleContext().setAccessibleName(this.m_helpMenu.getText());
            this.m_helpMenu.getAccessibleContext().setAccessibleDescription(this.m_helpMenu.getText());
            this.m_helpMenu.getAccessibleContext().setAccessibleParent(this);
            this.add(this.m_helpMenu);
            this.m_helpTopicsItem = VWStringUtils.getMenuItemUsingString(VWResource.HelpTopics_withHK);
            this.m_helpTopicsItem.setActionCommand(VWConfigActionCommand.ACMD_HELP_TOPICS);
            this.m_helpTopicsItem.addActionListener(this.m_configCore);
            this.m_helpTopicsItem.getAccessibleContext().setAccessibleName(this.m_helpTopicsItem.getText());
            this.m_helpTopicsItem.getAccessibleContext().setAccessibleDescription(this.m_helpTopicsItem.getText());
            this.m_helpTopicsItem.getAccessibleContext().setAccessibleParent(this.m_helpMenu);
            this.m_helpMenu.add(this.m_helpTopicsItem);
            this.m_aboutItem = VWStringUtils.getMenuItemUsingString(VWResource.AboutMenuItem_withHK);
            this.m_aboutItem.setActionCommand(VWConfigActionCommand.ACMD_ABOUT);
            this.m_aboutItem.addActionListener(this.m_configCore);
            this.m_aboutItem.getAccessibleContext().setAccessibleName(this.m_aboutItem.getText());
            this.m_aboutItem.getAccessibleContext().setAccessibleDescription(this.m_aboutItem.getText());
            this.m_aboutItem.getAccessibleContext().setAccessibleParent(this.m_helpMenu);
            this.m_helpMenu.add(this.m_aboutItem);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

